﻿//////////////////////////////////////////////
// InputDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "ClickEventData.h"
#include "EventTypes.h"
#include "KeyEventData.h"
#include "MouseMoveEventData.h"
#include "WheelEventData.h"

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT InputDescriptor final
	{
		public :

			// Functions
			// Constructor, destructor
			InputDescriptor (const KeyEventData& keyEvent) noexcept ;
			InputDescriptor (const ClickEventData& clickEvent) noexcept ;
			InputDescriptor (const MouseMoveEventData& mouseMoveEvent) noexcept ;
			InputDescriptor (const WheelEventData& wheelEvent) noexcept ;
			~InputDescriptor () ;

			// Getters
			EVENT_TYPE getType () const ;
			const KeyEventData& getKeyEvent () const ;
			const ClickEventData& getClickEvent () const ;
			const MouseMoveEventData& getMouseMoveEvent () const ;
			const WheelEventData& getWheelEvent () const ;

		private :

			// Attributes
			EVENT_TYPE _type ;

			union
			{
				// Keyboard event
				KeyEventData _keyEvent ;
				// Mouse events
				ClickEventData _clickEvent ;
				MouseMoveEventData _mouseMoveEvent ;
				WheelEventData _wheelEvent ;
			} ;
	} ;
}